 ; Ŀ
 ;   Boxer: place ascii boxes around comment lines in Lisp files.          
 ;   Copyright 1992  Rocket Software                                       
 ;   Why do they call those dogs "boxers", anyway?  They don't hit each    
 ;   other with their paws, I've never seen one gift-wrap anything...      
 ; 
  (DEFUN C:BOXER (/ count lina linb ttt iinn nnnn fn fo nextln len numm stop
                                               nexx posi ovrflo comlin exovr)
   (setvar "cmdecho" 0)
   (setq count 1)
 ; Ŀ
 ;   Set variables for top and bottom line borders.                        
 ; 
   (setq lina (strcat " ; "
                                   "Ŀ"))
   (setq linb (strcat " ; "
                                   ""))
 ; Ŀ
 ;   Get input (inn) and output (nn) filenames and open them.              
 ; 
   (if inn (setq ttt (strcat "Input filename <" inn ">: "))
           (setq ttt "Input filename: "))
   (setq iinn (Getstring ttt))
   (if (/= iinn "") (setq inn iinn))
   (if nn (setq ttt (strcat "Output filename <" nn ">: "))
           (setq ttt "Output filename: "))
   (setq nnnn (Getstring ttt))
   (if (/= nnnn "") (setq nn nnnn))
   (setq fn (open inn "r"))
   (setq fo (open nn "w"))
 ; Ŀ
 ;   The main loop.                                                        
 ; 
   (while (setq nextln (read-line fn))           ; while there is a next line
 ; Ŀ
 ;   (print nextln)                                                        
 ; 
          (grtext -2 (itoa count))               ; display line counter
          (setq count (1+ count))                ; and increment it
          (setq len (strlen nextln))             ; line length
          (setq numm 1)                          ; see if next line
          (setq stop ())                         ; flag: stop check for ; loop
 ; Ŀ
 ;   See if the current line starts with a semicolon:                      
 ;   While the stop flag isn't set, there's still some string left, and    
 ;   you're reading spaces, go through the string.  If you come to a ;     
 ;   then set Nexx to T, if you come to any other non-space character      
 ;   then set Nexx to ().  In either case set Stop to T to exit the loop.  
 ; 
          (while (and (<= numm len) (null stop))
                 (cond ((= (substr nextln numm 1) ";")
                        (setq stop T)
                        (setq nexx T))
                       ((/= (substr nextln numm 1) " ")
                        (setq stop T)
                        (setq nexx ()))
                       (T (setq numm (1+ numm)))))
 ; Ŀ
 ;   Check for the existence of previous boxed comments: if the first      
 ;   character of the line is between ascii 176 and 223 then treat it as   
 ;   a program line.  Only check comment lines (Nexx = T).                 
 ;   The program will now box only new comment lines, even if they are     
 ;   surrounded by previous (i.e. boxed) comments.                         
 ;   One could modify this to see if a comment line was before, after,     
 ;   or in the middle of an existing box, but the added complexity didn't  
 ;   seem worth a complete rewrite.                                        
 ; 
          (if (= nexx T)
              (progn
                   (while (and (< numm len)          ; find the next character
                               (or (= (substr nextln numm 1) " ")
                                   (= (substr nextln numm 1) ";")))
                          (setq numm (1+ numm)))
                   (setq stop (substr nextln numm 1))
 ; Ŀ
 ;   If the first character is a box drawing character, then treat as a    
 ;   program line.                                                         
 ; 
                   (if (and (<= (ascii stop) 223) (>= (ascii stop) 176))
                       (setq nexx ()))))
 ; Ŀ
 ;   Now: if Nexx = T the line is a comment so: get the part after the ;.  
 ;   Then: If the preceding line was a PROGRAM line then insert Lina       
 ;   (;Ŀ) and check to see if it's over  74 chars long.  If not then   
 ;   pad it to 74 and add  to the end.  If it is then check backwards     
 ;   from 74 for a space, pad the first part to 74 + , and put the last   
 ;   part in the overflow variable.  Also set comment to T.                
 ; 
          (cond ((= nexx T)
                  (while (or (= (substr nextln 1 1) " ")
                             (= (substr nextln 1 1) ";"))
                         (setq nextln (substr nextln 2)))
                  (if ovrflo
                      (progn
                           (setq nextln (strcat ovrflo " " nextln))
                           (while (= (substr nextln 1 1) " ")
                                  (setq nextln (substr nextln 2)))))
                  (setq nextln (strcat " ;   " nextln))
                  (if (> (strlen nextln) 74)
                      (progn
                           (setq len (strlen nextln))
                           (setq posi 75)
                           (while (and (/= (substr nextln posi 1) " ")
                                       (> posi 55))
                                  (setq posi (1- posi)))
                           (if (/= (substr nextln posi 1) " ")
                               (setq posi 74))
                           (setq ovrflo (substr nextln (1+ posi)))
                           (setq nextln (substr nextln 1 posi)))
                      (setq ovrflo ()))
                  (while (< (strlen nextln) 75)
                         (setq nextln (strcat nextln " ")))
                  (setq nextln (strcat nextln " "))
                  (if (null comlin) (write-line lina fo))
                  (setq comlin T)
                  (write-line nextln fo))
 ; Ŀ
 ;   If it's a program line it should be written to the output file        
 ;   unchanged.  First check to see if the "overflow from a comment line"  
 ;   variable is empty, if it is then do nothing, if it contains anything  
 ;   pad it to 74 and add  to the end, write it to the output file and    
 ;   set overflow and comment to ().                                       
 ;   Oh yeah: if the "last line was a comment line" variable is set then   
 ;   first write Linb (;) to the output file.                         
 ; 
                ((null nexx)      ; cond: this line is not a comment line
                  (if comlin      ; if last line was a comment line
                     (progn
 ; Ŀ
 ;   It's a prog line so write chunks of ovrflo to the output file until   
 ;   there's none left.                                                    
 ; 
                          (while ovrflo
                              (if (> (strlen ovrflo) 74)
                                  (progn
                                       (setq len (strlen ovrflo))
                                       (setq posi 75)
                                    (while (and (/= (substr ovrflo posi 1) " ")
                                                (> posi 55))
                                           (setq posi (1- posi)))
                                       (if (/= (substr nextln posi 1) " ")
                                           (setq posi 74))
                                       (setq exovr (substr ovrflo (1+ posi)))
                                       (setq ovrflo (substr ovrflo 1 posi)))
                                  (setq exovr ()))
                              (setq ovrflo (strcat " ;   " ovrflo))
                              (while (< (strlen ovrflo) 75)
                                     (setq ovrflo (strcat ovrflo " ")))
                              (setq ovrflo (strcat ovrflo " "))
                              (write-line ovrflo fo)
                              (setq ovrflo exovr))
                          (write-line linb fo)))    ; bottom of the box
                  (write-line nextln fo)            ; write prog line
                  (setq comlin ()))))               ; "last = com line" = nil
   (if comlin (write-line linb fo))
   (if fn (Close fn))
   (if fo (close fo))
  (PRINC))